/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.workflow;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.dialog.VWFieldUsageDialog;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWWorkflowGroupTableModel;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWUsersDialog;
import filenet.vw.toolkit.utils.table.VWDesignerParticipantListCellRenderer;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import filenet.vw.toolkit.utils.uicontrols.security.IVWParticipantSelectionDialog;
import filenet.vw.toolkit.utils.uicontrols.security.VWFilteredUsersAndGroupsDialog;
import filenet.vw.toolkit.utils.wfdefinition.VWDefaultSessionProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

class VWWorkflowGroupPanel
extends JPanel
implements TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener {
    private VWToolbarBorder m_wflGroupListToolBar = null;
    private VWTable m_wflGroupTable = null;
    private VWWorkflowGroupTableModel m_wflGroupTableModel = null;
    private VWToolbarBorder m_memberListToolBar = null;
    private JList m_memberList = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private IVWParticipantSelectionDialog m_usersDialog = null;

    VWWorkflowGroupPanel() {
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow();
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow > this.m_wflGroupTable.getRowCount() - 1) {
                    nRow = this.m_wflGroupTable.getRowCount() - 1;
                }
                if (nRow == this.m_wflGroupTable.getSelectedRow()) {
                    this.m_wflGroupTable.clearSelection();
                }
                this.m_wflGroupTable.setRowSelectionInterval(nRow, nRow);
                break;
            }
            case 0: {
                if (event.getColumn() != -1 || this.m_wflGroupTable.getSelectedRow() != event.getLastRow() || event.getSource() != this.m_wflGroupTableModel) break;
                this.onSelectedWflGroup();
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            if (event.getValueIsAdjusting()) {
                return;
            }
            if (event.getSource() == this.m_memberList) {
                this.onSelectedGroupMember();
            } else if (event.getSource() == this.m_wflGroupTable.getSelectionModel()) {
                this.onSelectedWflGroup();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            this.m_wflGroupTable.stopEditing();
            if (event.getSource() == this.m_wflGroupListToolBar) {
                int nRowIndex = this.m_wflGroupTable.getSelectedRow();
                if (nRowIndex == -1) {
                    return;
                }
                switch (event.getID()) {
                    case 64: {
                        this.m_wflGroupTableModel.copyItem(nRowIndex);
                        this.m_wflGroupTable.ensureRowIsVisible(this.m_wflGroupTable.getSelectedRow());
                        break;
                    }
                    case 0x10000000: {
                        this.m_wflGroupTableModel.deleteItem(nRowIndex);
                        break;
                    }
                    case 512: {
                        this.onFieldUsage();
                    }
                }
            } else if (event.getSource() == this.m_memberListToolBar) {
                switch (event.getID()) {
                    case 32: {
                        this.onModifyParticipants();
                        break;
                    }
                    case 0x10000000: {
                        this.onDeleteSelectedParticipants();
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void init(VWAuthPropertyData authPropertyData) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.createControls();
            this.reinitialize();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void reinitialize() {
        try {
            if (this.m_wflGroupTableModel != null) {
                this.m_wflGroupTableModel.reinitialize();
            }
            this.m_wflGroupTable.clearSelection();
            this.m_wflGroupTable.setRowSelectionInterval(0, 0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void stopEditing() {
        if (this.m_wflGroupTable != null) {
            this.m_wflGroupTable.stopEditing();
        }
    }

    protected void releaseReferences() {
        if (this.m_wflGroupListToolBar != null) {
            this.m_wflGroupListToolBar.removeToolbarBorderActionNotifier(this);
            this.m_wflGroupListToolBar.releaseReferences();
            this.m_wflGroupListToolBar = null;
        }
        if (this.m_wflGroupTable != null) {
            this.m_wflGroupTable.getSelectionModel().removeListSelectionListener(this);
            this.m_wflGroupTable.removeAll();
            this.m_wflGroupTable = null;
        }
        if (this.m_wflGroupTableModel != null) {
            this.m_wflGroupTableModel.removeTableModelListener(this);
            this.m_wflGroupTableModel = null;
        }
        if (this.m_memberListToolBar != null) {
            this.m_memberListToolBar.removeToolbarBorderActionNotifier(this);
            this.m_memberListToolBar.releaseReferences();
            this.m_memberListToolBar = null;
        }
        if (this.m_memberList != null) {
            this.m_memberList.removeListSelectionListener(this);
            this.m_memberList.removeAll();
            this.m_memberList = null;
        }
        if (this.m_usersDialog != null) {
            this.m_usersDialog.releaseReferences();
            this.m_usersDialog = null;
        }
        this.m_authPropertyData = null;
        this.removeAll();
    }

    private void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 1;
            gbCons.weightx = 0.7;
            gbCons.weighty = 1.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(7, 7, 7, 20);
            this.add((Component)this.createWflGroupsPanel(), gbCons);
            ++gbCons.gridx;
            gbCons.weightx = 0.3;
            gbCons.insets = new Insets(7, 7, 7, 7);
            this.add((Component)this.createMembersPanel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createWflGroupsPanel() {
        try {
            TableColumn tcElement;
            this.m_wflGroupListToolBar = new VWToolbarBorder(VWResource.s_workflowGroupsStr, 268436032);
            this.m_wflGroupListToolBar.addToolbarBorderActionNotifier(this);
            JPanel panel = this.m_wflGroupListToolBar.getClientPanel();
            panel.setLayout(new BorderLayout());
            this.m_wflGroupTableModel = new VWWorkflowGroupTableModel(this.m_authPropertyData);
            this.m_wflGroupTableModel.addTableModelListener(this);
            this.m_wflGroupTable = new VWTable(this.m_wflGroupTableModel);
            this.m_wflGroupTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_wflGroupTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            this.m_wflGroupTable.setRowSelectionAllowed(true);
            this.m_wflGroupTable.getSelectionModel().addListSelectionListener(this);
            this.m_wflGroupTable.getSelectionModel().setSelectionMode(0);
            if (this.m_authPropertyData.getShowInheritedProperties() && (tcElement = this.m_wflGroupTable.getColumnModel().getColumn(this.m_wflGroupTableModel.getActualColumnIndex(0))) != null) {
                tcElement.setMaxWidth(20);
                tcElement.setMinWidth(20);
            }
            panel.add((Component)new JScrollPane(this.m_wflGroupTable), "Center");
            return this.m_wflGroupListToolBar;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel createMembersPanel() {
        try {
            this.m_memberListToolBar = new VWToolbarBorder(VWResource.s_participants, 0x10000020);
            this.m_memberListToolBar.addToolbarBorderActionNotifier(this);
            JPanel panel = this.m_memberListToolBar.getClientPanel();
            panel.setLayout(new BorderLayout());
            this.m_memberList = new JList();
            this.m_memberList.addListSelectionListener(this);
            this.m_memberList.setCellRenderer(new VWDesignerParticipantListCellRenderer());
            panel.add((Component)new JScrollPane(this.m_memberList), "Center");
            return this.m_memberListToolBar;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void onSelectedWflGroup() {
        this.m_wflGroupListToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_wflGroupListToolBar.getClientPanel(), 2, Integer.MAX_VALUE));
        int nRowIndex = this.m_wflGroupTable.getSelectedRow();
        String wflGroupName = null;
        VWParticipant[] participants = null;
        if (this.m_wflGroupTableModel != null && nRowIndex != -1) {
            int nRowCount = this.m_wflGroupTableModel.getRowCount();
            wflGroupName = (String)this.m_wflGroupTableModel.getValueAt(nRowIndex, this.m_wflGroupTableModel.getActualColumnIndex(1));
            participants = (VWParticipant[])this.m_wflGroupTableModel.getValueAt(nRowIndex, this.m_wflGroupTableModel.getActualColumnIndex(3));
            if (nRowIndex != nRowCount - 1) {
                int nButtons = 64;
                if (VWStringUtils.compare(wflGroupName, "F_Trackers") != 0) {
                    nButtons |= 0x200;
                }
                if (this.m_wflGroupTableModel.canDeleteRow(nRowIndex)) {
                    nButtons |= 0x10000000;
                }
                this.m_wflGroupListToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_wflGroupListToolBar.getClientPanel(), 1, nButtons));
            }
        }
        VWParticipantItem[] participantItems = null;
        try {
            participantItems = VWDefaultSessionProxy.getFullParticipantItems(participants, true);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            if (this.m_authPropertyData != null) {
                String title = VWResource.s_invalidWorkflowGroupContents.toString(wflGroupName);
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), title, 1);
            }
            participantItems = VWDefaultSessionProxy.getParticipantItemsUsingParticipants(participants, false);
        }
        this.initializeMembersList(participantItems);
        if (!this.m_authPropertyData.getShowParticipants()) {
            this.m_memberListToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_memberListToolBar.getClientPanel(), 2, 32));
        }
    }

    private void initializeMembersList(VWParticipantItem[] participantItems) {
        try {
            VWSortedListModel listModel = new VWSortedListModel();
            if (participantItems != null) {
                for (int i = 0; i < participantItems.length; ++i) {
                    listModel.addElement(participantItems[i]);
                }
            }
            this.m_memberList.setModel(listModel);
            this.m_memberListToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_memberListToolBar.getClientPanel(), 2, 0x10000000));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onSelectedGroupMember() {
        int[] nRowIndices = this.m_memberList.getSelectedIndices();
        JPanel source = this.m_memberListToolBar.getClientPanel();
        if (!this.m_authPropertyData.getShowParticipants() || nRowIndices == null) {
            this.m_memberListToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 2, 0x10000000));
        } else {
            this.m_memberListToolBar.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 1, 0x10000000));
        }
    }

    private void onModifyParticipants() {
        try {
            VWSession vwSession = this.m_authPropertyData.getVWSession();
            if (vwSession == null) {
                return;
            }
            if (this.m_usersDialog == null) {
                this.m_usersDialog = vwSession.getSecurityDatabaseType() == 1 ? new VWFilteredUsersAndGroupsDialog(this.m_authPropertyData.getMainContainer(), vwSession) : new VWUsersDialog(this.m_authPropertyData.getMainContainer(), vwSession);
            }
            int nRowIndex = this.m_wflGroupTable.getSelectedRow();
            String wflGroupName = (String)this.m_wflGroupTableModel.getValueAt(nRowIndex, this.m_wflGroupTableModel.getActualColumnIndex(1));
            VWParticipantItem[] participantItems = null;
            ListModel listModel = this.m_memberList.getModel();
            if (listModel != null && listModel.getSize() > 0) {
                participantItems = new VWParticipantItem[listModel.getSize()];
                for (int i = 0; i < listModel.getSize(); ++i) {
                    participantItems[i] = (VWParticipantItem)listModel.getElementAt(i);
                }
            }
            this.m_usersDialog.init(participantItems, wflGroupName);
            this.m_usersDialog.setVisible(true);
            if (this.m_usersDialog.getStatus() == 1) {
                participantItems = this.m_usersDialog.getParticipants();
                VWParticipant[] participants = VWDefaultSessionProxy.getParticipantsFromParticipantItems(participantItems, false);
                this.m_wflGroupTableModel.setValueAt(participants, nRowIndex, this.m_wflGroupTableModel.getActualColumnIndex(3));
                this.initializeMembersList(participantItems);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onDeleteSelectedParticipants() {
        try {
            int[] indices = this.m_memberList.getSelectedIndices();
            if (indices.length == 0) {
                return;
            }
            DefaultListModel listModel = (DefaultListModel)this.m_memberList.getModel();
            for (int i = indices.length - 1; i >= 0; --i) {
                listModel.removeElementAt(indices[i]);
            }
            VWParticipant[] participants = new VWParticipant[listModel.getSize()];
            for (int i = 0; i < listModel.getSize(); ++i) {
                VWParticipantItem tmpItem = (VWParticipantItem)listModel.elementAt(i);
                if (tmpItem == null) continue;
                participants[i] = tmpItem.getVWParticipant();
            }
            this.m_wflGroupTableModel.setValueAt(participants, this.m_wflGroupTable.getSelectedRow(), this.m_wflGroupTableModel.getActualColumnIndex(3));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onFieldUsage() {
        try {
            int nRowIndex = this.m_wflGroupTable.getSelectedRow();
            String fieldName = (String)this.m_wflGroupTableModel.getValueAt(nRowIndex, this.m_wflGroupTableModel.getActualColumnIndex(1));
            if (this.m_authPropertyData != null) {
                VWFieldDefinition fieldDef = this.m_authPropertyData.getField(fieldName);
                VWFieldUsageDialog fieldUsageDialog = new VWFieldUsageDialog(this.m_authPropertyData.getMainContainer());
                fieldUsageDialog.init(this.m_authPropertyData, fieldDef);
                if (fieldUsageDialog.hasMaps()) {
                    fieldUsageDialog.setVisible(true);
                } else {
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), VWResource.s_noAvailableWritableMaps, 2);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

